﻿//////////////////////////////////////////////
// Theme.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Color.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Internals --------------------------------

namespace nkWinUi
{
	struct DLL_WINUI_EXPORT ThemeColors
	{
		// Enabled
		// Couleur primaire
		Color _primaryColor ;
		// Secondaire
		Color _secondaryColor ;
		// Ter
		Color _ternaryColor ;

		// Hovering
		Color _hoverColor ;

		// Texte
		Color _textColor ;
	} ;
}

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Theme final
	{
		public :
	
			// Constructor
			Theme () noexcept ;

			// Getters
			nkMemory::StringView getName () const ;
			const ThemeColors& getColors () const ;
			ThemeColors& getColors () ;

			// Setters
			void setName (nkMemory::StringView name) ;

		public :

			// Statics
			static nkMemory::UniquePtr<Theme> create (System* system = nullptr) ;

		private :

			// Attributes
			nkMemory::String _name ;
			ThemeColors _colors ;
	} ;
}